using Unity.Burst;
using Unity.Collections;
using Unity.Entities;
using Unity.Mathematics;
using Unity.Transforms;

[BurstCompile]
[UpdateInGroup(typeof(InitializationSystemGroup))]
public partial struct CubeSpawnerSystem : ISystem
{
    public void OnCreate(ref SystemState state)
    {
        // Chỉ chạy nếu EntitiesReferences tồn tại
        state.RequireForUpdate<EntitiesReferences>();
    }

    public void OnUpdate(ref SystemState state)
    {
        state.Enabled = false;

        var entityManager = state.EntityManager;

        // Lấy prefab từ EntitiesReferences singleton
        var prefabEntity = SystemAPI.GetSingleton<EntitiesReferences>().cubePrefab;

        var ecb = new EntityCommandBuffer(Allocator.Temp);

        for (int i = 0; i < 30000; i++)
        {
            var entity = ecb.Instantiate(prefabEntity);

            float3 pos = new float3(
                UnityEngine.Random.Range(-10f, 10f),
                UnityEngine.Random.Range(-5f, 5f),
                UnityEngine.Random.Range(-5f, 5f)
            );

            ecb.SetComponent(entity, LocalTransform.FromPosition(pos));
        }

        ecb.Playback(entityManager);
        ecb.Dispose();
    }
}
