using Unity.Burst;
using Unity.Entities;
using Unity.Transforms;
using Unity.Jobs;

[BurstCompile]
[UpdateInGroup(typeof(SimulationSystemGroup))]
public partial struct CubeMoverSystem : ISystem
{
    [BurstCompile]
    public partial struct CubeMoverJob : IJobEntity
    {
        public float DeltaTime;

        public void Execute(ref LocalTransform transform, in CubeMoverComponent mover)
        {
            transform.Position.x += mover.Speed * DeltaTime;
            if (transform.Position.x > 10f)
                transform.Position.x = -10f;
        }
    }

    public void OnUpdate(ref SystemState state)
    {
        var job = new CubeMoverJob
        {
            DeltaTime = SystemAPI.Time.DeltaTime
        };

        state.Dependency = job.Schedule(state.Dependency);
    }
}