using Unity.Entities;
using Unity.Mathematics;
using Unity.Transforms;
using Unity.Burst;

[BurstCompile]
public partial struct HelloWorldSystem : ISystem
{
    public void OnUpdate(ref SystemState state)
    {
        float deltaTime = SystemAPI.Time.DeltaTime;

        foreach (var (transform, helloWorld) in SystemAPI.Query<RefRW<LocalTransform>, RefRO<HelloWorldComponent>>())
        {
            // Di chuyển entity theo trục X
            transform.ValueRW.Position.x += helloWorld.ValueRO.Speed * deltaTime;

            // Reset vị trí khi đi quá xa
            if (transform.ValueRO.Position.x > 10f)
            {
                transform.ValueRW.Position.x = -10f;
            }
        }
    }
}