using Unity.Entities;
using Unity.Mathematics;
using UnityEngine;

public class HelloWorldAuthoring : MonoBehaviour
{
    [SerializeField] private float speed = 5f;

    class Baker : Baker<HelloWorldAuthoring>
    {
        public override void Bake(HelloWorldAuthoring authoring)
        {
            var entity = GetEntity(TransformUsageFlags.Dynamic);
            AddComponent(entity, new HelloWorldComponent
            {
                Speed = authoring.speed
            });
        }
    }
}

// Định nghĩa Component
public struct HelloWorldComponent : IComponentData
{
    public float Speed;
}